/*jslint unparam: true, browser: true, indent: 2 */

;(function ($, window, document, undefined) {
  'use strict';

  Foundation.libs.magellan = {
    name : 'magellan',

    version : '4.2.2',

    settings : {
      activeClass: 'active',
      // thresold :
      // - si 0, calculé automatiquement à la hauteur du menu - i.e. une hauteur avant d'atteindre le menu, il est attire par le sommet !
      // - si négatif, va au delà du menu
      // - si positif, avant d'atteindre le menu
      threshold: -24, // légèrement négatif, pour permettre de toucher le menu et de le dépasser avant de le river au sommet
      threshold_arrival: 24 // légèrement positif, pour mettre à jour l'état avant d'atteindre l'ancre
    },

    old_windowScrollTop : 0,

    init : function (scope, method, options) {
      this.scope = scope || this.scope;
      Foundation.inherit(this, 'data_options');

      if (typeof method === 'object') {
        $.extend(true, this.settings, method);
      }

      if (typeof method !== 'string') {
        if (!this.settings.init) {
          this.fixed_magellan = $("[data-magellan-expedition]");
          this.set_threshold();
          this.last_destination = $('[data-magellan-destination]').last();
          this.events();
        }

        return this.settings.init;
      } else {
        return this[method].call(this, options);
      }
    },

    events : function () {
      var self = this;
      $(this.scope).on('arrival.fndtn.magellan', '[data-magellan-arrival]', function (e) {
        var $destination = $(this),
            $expedition = $destination.closest('[data-magellan-expedition]'),
            activeClass = $expedition.attr('data-magellan-active-class') 
              || self.settings.activeClass;

          $destination
            .closest('[data-magellan-expedition]')
            .find('[data-magellan-arrival]')
            .not($destination)
            .removeClass(activeClass);
          $destination.addClass(activeClass);
      });

      this.fixed_magellan
        .on('update-position.fndtn.magellan', function(){
          var $el = $(this);
          /*
          $el.data("magellan-fixed-position","");
          $el.data("magellan-top-offset", "");
          */
          // 
          // Conserve la position courante de la fenetre pour ne pas avoir a la recalculer
          this.old_windowScrollTop = $(window).scrollTop();
          // console.log('windowScrol '+ this.old_windowScrollTop);
        })
        .trigger('update-position');

      $(window)
        .on('resize.fndtn.magellan', function() {
          this.fixed_magellan.trigger('update-position');
        }.bind(this))

        .on('scroll.fndtn.magellan', function() {
          var windowScrollTop = $(window).scrollTop();
          self.fixed_magellan.each(function() {
            var $expedition = $(this);
            if (typeof $expedition.data('magellan-top-offset') === 'undefined') {
              $expedition.data('magellan-top-offset', $expedition.offset().top);
            }
            if (typeof $expedition.data('magellan-fixed-position') === 'undefined') {
              $expedition.data('magellan-fixed-position', false)
            }

            var fixed_position = (windowScrollTop + self.settings.threshold) > $expedition.data("magellan-top-offset");
            var attr = $expedition.attr('data-magellan-top-offset');

            if ($expedition.data("magellan-fixed-position") != fixed_position) {

              $expedition.data("magellan-fixed-position", fixed_position);

              if ( fixed_position ) {

                // On modifie la position en changeant le style
                $expedition.addClass('fixed');
                $expedition.css({position:"fixed", top:0});

                // ACO: ajuste la position si necessaire
                // le premier test, vérifie qu'on n'est pas dans le cas d'un rechargement
                if ( this.old_windowScrollTop > 0 ) {
                  // En cas de refresh du navigateur, la position courante dans la page est conservée.
                  // Mais comme cette position est déjà correcte, puisqu'elle prend en compte la hauteur du menu, il est inutile de la modifier.
                  this.old_windowScrollTop = 0;
                }
                else {
                  var old_pos = windowScrollTop; // la position courante
                  var menu_pos = $expedition.data("magellan-top-offset"); // la position d'origine du menu
                  var menu_height =  $expedition.height(); // la hauteur de menu
                  var new_pos = 0; // la nouvelle position
                  var opt = 0;
                  
                  // La fixation du menu l'enlève du flot normal ce qui déplace la position courante
                  // 1- si le menu est avant la position courante, il faut supprimer la hauteur du menu
                  if (menu_pos + menu_height <= old_pos) {
                    new_pos = old_pos - menu_height;
                    opt = 1;
                  }
                  // 2- si le menu est après la position courante, rien ne change
                  else if (menu_pos > old_pos) {
                    new_pos = old_pos;
                    opt = 2;
                  }
                  // 3 - enfin si le menu est partiellement apparent, on revient à la position du menu
                  else {
                    new_pos = menu_pos; // juste avant
                    opt = 3;
                  }
                  // Cependant, cette nouvelle position va être masquée par le menu qui vient en surimpresison.
                  // Pour la rendre apparente il faut la décaler vers le bas
                  // et donc inverselement la position de la fenêtre est décalée vers le haut de la hauteur du menu.
                  //new_pos = new_pos - menu_height;

                  // Réajuste si necessaire dans la zone de transition
                  if ( (new_pos + self.settings.threshold) <= $expedition.data("magellan-top-offset") ) {
                    new_pos = $expedition.data("magellan-top-offset") - self.settings.threshold + 1;
                  }
                  window.scrollTo(0, new_pos);

                  //console.log('old_pos:' + old_pos + ', new_pos:' + new_pos + ', menu_pos:' + menu_pos + ', menu_height:' + menu_height + ', opt:' + opt);

                }

              } else {
                $expedition.removeClass('fixed');
                $expedition.css({position:"", top:""});
                //console.log ('Unfixed');
              }
              if (fixed_position && typeof attr != 'undefined' && attr !== false) {
                $expedition.css({position:"fixed", top:attr + "px"});
              }
            }
          });
        });


      if (this.last_destination.length > 0) {
        $(window).on('scroll.fndtn.magellan', function (e) {
          var windowScrollTop = $(window).scrollTop(),
              scrolltopPlusHeight = windowScrollTop + $(window).height(),
              lastDestinationTop = Math.ceil(self.last_destination.offset().top);

          $('[data-magellan-destination]').each(function () {
            var $destination = $(this),
                destination_name = $destination.attr('data-magellan-destination'),
                destination_offset = Math.floor($destination.offset().top),
                topOffset = destination_offset - windowScrollTop;
            //console.log('name:'+destination_name+', destination:'+destination_offset+', scrollTop:'+windowScrollTop);
            if (topOffset <= self.settings.threshold_arrival) {
              $("[data-magellan-arrival='" + destination_name + "']").trigger('arrival');
            }
            // In large screens we may hit the bottom of the page and dont reach the top of the last magellan-destination, so lets force it
            if (scrolltopPlusHeight >= $(self.scope).height() && lastDestinationTop > windowScrollTop && lastDestinationTop < scrolltopPlusHeight) {
              $('[data-magellan-arrival]').last().trigger('arrival');
            }
          });
        });
      }

      this.settings.init = true;
    },

    set_threshold : function () {
      if (!this.settings.threshold) {
        this.settings.threshold = (this.fixed_magellan.length > 0) ? 
          this.outerHeight(this.fixed_magellan, true) : 0;
      }
    },

    off : function () {
      $(this.scope).off('.fndtn.magellan');
    },

    reflow : function () {}
  };
}(Foundation.zj, this, this.document));
